/*
 * Decompiled with CFR 0.152.
 */
package filenet.ws.utils;

import filenet.vw.base.VWString;
import filenet.vw.base.VWXMLWrapper;
import filenet.vw.base.logging.Level;
import filenet.vw.base.logging.Logger;
import filenet.vw.ntutil.QTimer;
import filenet.vw.toolkit.utils.VWCommandLineArgs;
import filenet.ws.api.WSDefinition;
import filenet.ws.utils.WSConstants;
import filenet.ws.utils.WSSchemaValidatorResult;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Vector;
import org.apache.xerces.parsers.IntegratedParserConfiguration;
import org.apache.xerces.parsers.XMLGrammarPreparser;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.util.XMLGrammarPoolImpl;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.grammars.Grammar;
import org.apache.xerces.xni.grammars.XMLGrammarPool;
import org.apache.xerces.xni.parser.XMLErrorHandler;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.apache.xerces.xni.parser.XMLParseException;
import org.apache.xerces.xni.parser.XMLParserConfiguration;
import org.w3c.dom.Node;

public class WSSchemaValidator
implements XMLErrorHandler {
    protected static final Logger logger = Logger.getLogger("filenet.ws.utils");
    protected static final String m_className = "WSSchemaValidator";
    private WSSchemaValidatorResult m_result = null;
    private boolean isValid = true;
    public static final String SYMBOL_TABLE = "http://apache.org/xml/properties/internal/symbol-table";
    public static final String GRAMMAR_POOL = "http://apache.org/xml/properties/internal/grammar-pool";
    protected static final String NAMESPACES_FEATURE_ID = "http://xml.org/sax/features/namespaces";
    protected static final String VALIDATION_FEATURE_ID = "http://xml.org/sax/features/validation";
    protected static final String SCHEMA_VALIDATION_FEATURE_ID = "http://apache.org/xml/features/validation/schema";
    protected static final String SCHEMA_FULL_CHECKING_FEATURE_ID = "http://apache.org/xml/features/validation/schema-full-checking";
    protected static final String HONOUR_ALL_SCHEMA_LOCATIONS_FEATURE_ID = "http://apache.org/xml/features/honour-all-schemaLocations";
    public static final int BIG_PRIME = 2039;
    private static XMLParserConfiguration global_parserConfiguration = null;
    private static SymbolTable global_sym = null;
    private static XMLGrammarPoolImpl global_grammarPool = null;
    private static XMLGrammarPreparser global_preparser = null;
    private static Boolean global_variables_init = Boolean.FALSE;
    private static final Object g_syncObj = new Object();
    protected static boolean useLocal = true;

    public static String _get_FILE_DATE() {
        return "$Date:   15 Oct 2008 18:20:12  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   qdang  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.18  $";
    }

    public WSSchemaValidator(WSSchemaValidatorResult result) {
        this.m_result = result;
    }

    public boolean IsValid() {
        return this.isValid;
    }

    public WSSchemaValidatorResult getResult() {
        return this.m_result;
    }

    public void warning(String domain, String key, XMLParseException exception) throws XNIException {
        String s = new VWString("filenet.ws.utils.WSSchemaValidator.warning", "[Warning] {0}: line {1}, column {2}, {3}").toString(new Object[]{exception.getLiteralSystemId(), Integer.toString(exception.getLineNumber()), Integer.toString(exception.getColumnNumber()), exception.getLocalizedMessage()});
        logger.warning(m_className, "warning", s);
    }

    public void error(String domain, String key, XMLParseException exception) throws XNIException {
        String s = new VWString("filenet.ws.utils.WSSchemaValidator.error", "[Error] {0}: line {1}, column {2}, {3}").toString(new Object[]{exception.getLiteralSystemId(), Integer.toString(exception.getLineNumber()), Integer.toString(exception.getColumnNumber()), exception.getLocalizedMessage()});
        logger.warning(m_className, "error", s);
        if (this.m_result != null) {
            this.m_result.setValid(false);
            this.m_result.addError(s);
        }
        this.isValid = false;
    }

    public void fatalError(String domain, String key, XMLParseException exception) throws XNIException {
        String s = new VWString("filenet.ws.utils.WSSchemaValidator.fatalError", "[Fatal Error] {0}: line {1}, column {2}, {3}").toString(new Object[]{exception.getLiteralSystemId(), Integer.toString(exception.getLineNumber()), Integer.toString(exception.getColumnNumber()), exception.getLocalizedMessage()});
        logger.warning(m_className, "fatalError", s);
        if (this.m_result != null) {
            this.m_result.setValid(false);
            this.m_result.addError(s);
        }
        this.isValid = false;
        throw exception;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void initGlobals() {
        Object object = g_syncObj;
        synchronized (object) {
            if (!global_variables_init.booleanValue()) {
                global_grammarPool = new XMLGrammarPoolImpl();
                global_sym = new SymbolTable(2039);
                global_parserConfiguration = new IntegratedParserConfiguration(global_sym, (XMLGrammarPool)global_grammarPool);
                global_preparser = new XMLGrammarPreparser(global_sym);
                global_preparser.registerPreparser("http://www.w3.org/2001/XMLSchema", null);
                global_preparser.setProperty(GRAMMAR_POOL, (Object)global_grammarPool);
                global_preparser.setFeature(NAMESPACES_FEATURE_ID, true);
                global_preparser.setFeature(VALIDATION_FEATURE_ID, true);
                global_preparser.setFeature(SCHEMA_VALIDATION_FEATURE_ID, true);
                global_preparser.setFeature(SCHEMA_FULL_CHECKING_FEATURE_ID, true);
                global_preparser.setFeature(HONOUR_ALL_SCHEMA_LOCATIONS_FEATURE_ID, true);
                global_variables_init = Boolean.TRUE;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void resetGlobals() {
        Object object = g_syncObj;
        synchronized (object) {
            global_parserConfiguration = null;
            global_sym = null;
            global_grammarPool = null;
            global_preparser = null;
            global_variables_init = Boolean.FALSE;
        }
    }

    public static void setLocal(boolean val) {
        useLocal = val;
    }

    private static void reOrder(String[] schemas, String[] schemaIds) {
        boolean reordered = false;
        if (schemas == null) {
            return;
        }
        int nSchemas = schemas == null ? 0 : schemas.length;
        Vector v = new Vector();
        Vector<String> vTns = new Vector<String>();
        Vector<Boolean> vHasImportToReordered = new Vector<Boolean>();
        for (int i = 0; i < nSchemas; ++i) {
            try {
                VWXMLWrapper vwxmlWrapper = new VWXMLWrapper(schemas[i]);
                String targetNS = VWXMLWrapper.getNodeAttribute(vwxmlWrapper.getRootNode(), "targetNamespace");
                vTns.add(targetNS);
                Node[] importNodes = VWXMLWrapper.getNodesNamed(vwxmlWrapper.getRootNode(), "import");
                int nNodes = importNodes == null ? 0 : importNodes.length;
                Vector<String> importSchemasV = new Vector<String>();
                Boolean hasImportToReordered = Boolean.FALSE;
                for (int k = 0; k < nNodes; ++k) {
                    String namespace;
                    String locationAttribute = VWXMLWrapper.getNodeAttribute(importNodes[k], "schemaLocation");
                    if (locationAttribute != null || (namespace = VWXMLWrapper.getNodeAttribute(importNodes[k], "namespace")) == null || vTns.contains(namespace)) continue;
                    importSchemasV.add(namespace);
                    hasImportToReordered = Boolean.TRUE;
                    reordered = true;
                }
                v.add(importSchemasV);
                vHasImportToReordered.add(hasImportToReordered);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (reordered) {
            int index = vHasImportToReordered.indexOf(Boolean.TRUE);
            if (index == -1) {
                return;
            }
            for (int i = index; i < nSchemas; ++i) {
                Vector importSchemasV;
                if (!((Boolean)vHasImportToReordered.get(i)).booleanValue() || (importSchemasV = (Vector)v.get(i)).isEmpty()) continue;
                int bigIndex = i;
                for (String ns : importSchemasV) {
                    int where = vTns.indexOf(ns);
                    if (where <= bigIndex) continue;
                    bigIndex = where;
                }
                String s = schemas[i];
                schemas[i] = schemas[bigIndex];
                schemas[bigIndex] = s;
                s = schemaIds[i];
                schemaIds[i] = schemaIds[bigIndex];
                schemaIds[bigIndex] = s;
            }
        }
    }

    private static void printSchemas(String[] schemas, String[] schemaIds) {
        int nSchemas = schemas == null ? 0 : schemas.length;
        for (int i = 0; i < nSchemas; ++i) {
            logger.finest(m_className, "printSchemas", "Schemas[" + i + "]=" + schemaIds[i] + ", " + schemas[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static WSSchemaValidatorResult validate(String[] schemaIds, String instanceId, String[] schemas, String instance) {
        String m_method = "validate";
        logger.entering(m_className, "validate");
        WSSchemaValidator.reOrder(schemas, schemaIds);
        if (logger.isFinest()) {
            WSSchemaValidator.printSchemas(schemas, schemaIds);
        }
        WSSchemaValidatorResult res = new WSSchemaValidatorResult(schemaIds, instanceId);
        try {
            String errorString;
            WSSchemaValidatorResult wSSchemaValidatorResult;
            if (schemas == null) {
                res.setValid(false);
                String errorString2 = new VWString("filenet.ws.utils.WSSchemaValidator.NullSchema", "Null schema.").toString();
                res.addError(errorString2);
                WSSchemaValidatorResult wSSchemaValidatorResult2 = res;
                Object var21_10 = null;
                logger.exiting(m_className, "validate");
                return wSSchemaValidatorResult2;
            }
            WSSchemaValidator errorHandler = new WSSchemaValidator(res);
            IntegratedParserConfiguration local_parserConfiguration = null;
            SymbolTable local_sym = null;
            XMLGrammarPoolImpl local_grammarPool = null;
            XMLGrammarPreparser local_preparser = null;
            XMLParserConfiguration parserConfiguration = null;
            XMLGrammarPreparser preparser = null;
            if (useLocal) {
                local_grammarPool = new XMLGrammarPoolImpl();
                local_sym = new SymbolTable(2039);
                local_parserConfiguration = new IntegratedParserConfiguration(local_sym, (XMLGrammarPool)local_grammarPool);
                local_preparser = new XMLGrammarPreparser(local_sym);
                local_preparser.registerPreparser("http://www.w3.org/2001/XMLSchema", null);
                local_preparser.setProperty(GRAMMAR_POOL, (Object)local_grammarPool);
                local_preparser.setFeature(NAMESPACES_FEATURE_ID, true);
                local_preparser.setFeature(VALIDATION_FEATURE_ID, true);
                local_preparser.setFeature(SCHEMA_VALIDATION_FEATURE_ID, true);
                local_preparser.setFeature(SCHEMA_FULL_CHECKING_FEATURE_ID, true);
                local_preparser.setFeature(HONOUR_ALL_SCHEMA_LOCATIONS_FEATURE_ID, true);
                parserConfiguration = local_parserConfiguration;
                preparser = local_preparser;
            } else {
                WSSchemaValidator.initGlobals();
                parserConfiguration = global_parserConfiguration;
                preparser = global_preparser;
            }
            int nSchemas = schemas.length;
            if (schemaIds == null) {
                schemaIds = new String[nSchemas];
                for (int i = 0; i < nSchemas; ++i) {
                    schemaIds[i] = Integer.toString(i);
                }
            }
            Object object = preparser;
            // MONITORENTER : object
            preparser.setErrorHandler((XMLErrorHandler)errorHandler);
            for (int i = 0; i < nSchemas; ++i) {
                try {
                    String schemaId = schemaIds[i];
                    Grammar g = preparser.preparseGrammar("http://www.w3.org/2001/XMLSchema", WSSchemaValidator.streamToXIS("SCHEMA://" + schemaId, new ByteArrayInputStream(schemas[i].getBytes("UTF-8")), "UTF-8"));
                    continue;
                }
                catch (Exception e) {
                    logger.throwing(m_className, "validate", e);
                    res.setValid(false);
                    if (!(e instanceof XNIException)) {
                        String errorString3 = new VWString("filenet.ws.utils.WSSchemaValidator.GrammarParsingException", "Grammar Parsing exception: {0}").toString(e.getMessage());
                        res.addError(errorString3);
                    }
                    wSSchemaValidatorResult = res;
                    // MONITOREXIT : object
                    Object var21_11 = null;
                    logger.exiting(m_className, "validate");
                    return wSSchemaValidatorResult;
                }
            }
            // MONITOREXIT : object
            if (!errorHandler.IsValid()) {
                logger.warning(m_className, "validate", "Schemas has errors..");
                object = res;
                Object var21_12 = null;
                logger.exiting(m_className, "validate");
                return object;
            }
            if (instance == null || instance.trim().length() == 0) {
                object = res;
                Object var21_13 = null;
                logger.exiting(m_className, "validate");
                return object;
            }
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(m_className, "validate", "Instance=" + instance);
            }
            object = parserConfiguration;
            // MONITORENTER : object
            try {
                parserConfiguration.setFeature(NAMESPACES_FEATURE_ID, true);
                parserConfiguration.setFeature(VALIDATION_FEATURE_ID, true);
                parserConfiguration.setFeature(SCHEMA_VALIDATION_FEATURE_ID, true);
                parserConfiguration.setFeature(SCHEMA_FULL_CHECKING_FEATURE_ID, true);
                parserConfiguration.setFeature(HONOUR_ALL_SCHEMA_LOCATIONS_FEATURE_ID, true);
            }
            catch (Exception e) {
                logger.throwing(m_className, "validate", e);
                res.setValid(false);
                errorString = new VWString("filenet.ws.utils.WSSchemaValidator.ParserFeaturesFailure", "Failed to set parser features: {0}").toString(e.getMessage());
                res.addError(errorString);
                wSSchemaValidatorResult = res;
                // MONITOREXIT : object
                Object var21_14 = null;
                logger.exiting(m_className, "validate");
                return wSSchemaValidatorResult;
            }
            try {
                parserConfiguration.setErrorHandler((XMLErrorHandler)errorHandler);
                parserConfiguration.parse(WSSchemaValidator.streamToXIS("XMLINSTANCE://" + instanceId, new ByteArrayInputStream(instance.getBytes("UTF-8")), "UTF-8"));
            }
            catch (Exception e) {
                logger.throwing(m_className, "validate", e);
                res.setValid(false);
                if (!(e instanceof XNIException)) {
                    errorString = new VWString("filenet.ws.utils.WSSchemaValidator.ParserFailure", "Parser Failure: {0}").toString(e.getMessage());
                    res.addError(errorString);
                }
                WSSchemaValidatorResult wSSchemaValidatorResult3 = res;
                // MONITOREXIT : object
                Object var21_15 = null;
                logger.exiting(m_className, "validate");
                return wSSchemaValidatorResult3;
            }
            object = res;
            Object var21_16 = null;
            logger.exiting(m_className, "validate");
            return object;
        }
        catch (Throwable throwable) {
            Object var21_17 = null;
            logger.exiting(m_className, "validate");
            throw throwable;
        }
    }

    private static XMLInputSource stringToXIS(String uri) {
        return new XMLInputSource(null, uri, null);
    }

    private static XMLInputSource streamToXIS(String systemId, InputStream byteStream, String encoding) {
        return new XMLInputSource(systemId, systemId, systemId, byteStream, encoding);
    }

    private static String[] testSchema1() throws Exception {
        StringBuffer buf = new StringBuffer();
        buf.append("<xsd:schema elementFormDefault=\"qualified\"");
        buf.append(" targetNamespace=\"http://www.filenet.com/process/p8-3x/2004/WF1/BNSchema\"");
        buf.append(" xmlns:tns=\"http://www.filenet.com/process/p8-3x/2004/WF1/BNSchema\" ");
        buf.append(" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\">");
        buf.append("    <xsd:element name=\"GetBNQuote\">");
        buf.append("        <xsd:complexType>");
        buf.append("            <xsd:sequence>");
        buf.append("                <xsd:element maxOccurs=\"1\" minOccurs=\"0\" name=\"sISBN\" type=\"xsd:string\"/>");
        buf.append("            </xsd:sequence>");
        buf.append("        </xsd:complexType>");
        buf.append("    </xsd:element>");
        buf.append("</xsd:schema>");
        return new String[]{buf.toString()};
    }

    private static String[] testSchema2() throws Exception {
        return new String[]{WSConstants.getDefaultWSConstants().P8BPM_SCHEMA_REPLYHEADER};
    }

    private static String testInstance1() throws Exception {
        StringBuffer buf = new StringBuffer();
        buf.append("<GetBNQuote xmlns=\"http://www.filenet.com/process/p8-3x/2004/WF1/BNSchema\">");
        buf.append("    <sISBN>string</sISBN>");
        buf.append("    <sISBN>string2</sISBN>");
        buf.append("</GetBNQuote>");
        return buf.toString();
    }

    private static String testInstance2() throws Exception {
        StringBuffer buf = new StringBuffer();
        buf.append("<ReplyHeader xmlns=\"").append(WSConstants.getDefaultWSConstants().P8BPM_NS_GENERIC).append("\">\n");
        buf.append("    <MessageID xmlns=\"").append("http://schemas.xmlsoap.org/ws/2003/03/addressing").append("\">\n");
        buf.append("        anyURI");
        buf.append("    </MessageID>");
        buf.append("    <ReplyTo xmlns=\"").append("http://schemas.xmlsoap.org/ws/2003/03/addressing").append("\">\n");
        buf.append("        <Address>");
        buf.append("            anyURI");
        buf.append("        </Address>");
        buf.append("        <ReferenceProperties><replySOAPHeader>abc</replySOAPHeader>");
        buf.append("        </ReferenceProperties>");
        buf.append("        <PortType>");
        buf.append("            QName");
        buf.append("        </PortType>");
        buf.append("        <ServiceName>");
        buf.append("            QName");
        buf.append("        </ServiceName>");
        buf.append("    </ReplyTo>");
        buf.append("</ReplyHeader>");
        return buf.toString();
    }

    private static void reportRes(WSSchemaValidatorResult res) {
        System.out.println(res);
    }

    public static void main(String[] args) {
        try {
            String wsdl;
            String inputFile;
            WSSchemaValidatorResult res = null;
            if (args.length == 0) {
                System.out.println("DONE.");
                System.exit(0);
            } else {
                System.out.println("Got to work..");
            }
            VWCommandLineArgs c = new VWCommandLineArgs(args);
            if (c.isPresent("h")) {
                WSSchemaValidator.printUsage();
            }
            if ((inputFile = c.getParameter("inputfile")) != null) {
                c = new VWCommandLineArgs(inputFile, false);
            }
            if ((wsdl = c.getParameter("wsdl")) != null) {
                QTimer timer = new QTimer();
                String inputMsg = null;
                String inputMsgFile = c.getParameter("in");
                if (inputMsgFile != null) {
                    inputMsg = new String(WSSchemaValidator.readFile(inputMsgFile));
                }
                c.list(System.out);
                WSDefinition def = new WSDefinition(wsdl);
                String[] schemaTNSs = def.getSchemasTNS();
                System.out.println("SCHEMA TargetNamespaces=");
                System.out.println(Logger.asString(schemaTNSs));
                String[] schemas = def.getSchemas();
                System.out.println("SCHEMAS=");
                System.out.println(Logger.asString(schemas));
                res = WSSchemaValidator.validate(schemaTNSs, c.getParameter("op", "Instance"), schemas, inputMsg);
                WSSchemaValidator.reportRes(res);
                timer.stop();
                System.out.println("Took: " + timer.elapsed() + " ms");
                System.exit(0);
            }
            String[] instanceFiles = WSSchemaValidator.getParameters(c, "i", "XML instance");
            String[] schemaFiles = WSSchemaValidator.getParameters(c, "s", "XML Schema");
            String[] instanceFileContents = WSSchemaValidator.getContentsFromFiles(instanceFiles, "XML instance");
            String[] schemaFileContents = WSSchemaValidator.getContentsFromFiles(schemaFiles, "XML schema");
            int nInstances = instanceFileContents.length;
            QTimer timer = new QTimer();
            for (int i = 0; i < nInstances; ++i) {
                res = WSSchemaValidator.validate(schemaFiles, instanceFiles[i], schemaFileContents, instanceFileContents[i]);
                WSSchemaValidator.reportRes(res);
            }
            timer.stop();
            System.out.println("Took: " + timer.elapsed() + " ms");
        }
        catch (Exception e) {
            e.printStackTrace();
            WSSchemaValidator.printUsage();
        }
        System.exit(0);
    }

    private static String[] getParameters(VWCommandLineArgs c, String type, String typeDesc) throws Exception {
        String[] schemaFiles = null;
        int nSchemas = c.getIntParameter("n" + type, 0);
        if (nSchemas == 0) {
            String s = c.getParameter(type);
            if (s == null) {
                throw new Exception("Missing " + typeDesc);
            }
            schemaFiles = new String[]{s};
        } else {
            schemaFiles = new String[nSchemas];
            for (int i = 1; i <= nSchemas; ++i) {
                String s;
                String paramName = type + Integer.toString(i);
                schemaFiles[i - 1] = s = c.getParameter(paramName);
                if (s != null) continue;
                throw new Exception("Missing " + paramName + " for " + typeDesc);
            }
        }
        return schemaFiles;
    }

    private static String[] getContentsFromFiles(String[] files, String typeDesc) throws Exception {
        if (files == null || files.length == 0) {
            throw new Exception("No " + typeDesc);
        }
        int nItems = files.length;
        String[] res = new String[nItems];
        for (int i = 0; i < nItems; ++i) {
            res[i] = new String(WSSchemaValidator.readFile(files[i]));
        }
        return res;
    }

    private static byte[] readFile(String fileName) throws Exception {
        byte[] byArray;
        BufferedInputStream inStream;
        block8: {
            block6: {
                byte[] byArray2;
                block7: {
                    File fileInfo = null;
                    inStream = null;
                    byte[] contents = null;
                    fileInfo = new File(fileName);
                    inStream = new BufferedInputStream(new FileInputStream(fileName));
                    int len = (int)fileInfo.length();
                    if (len <= 0) break block6;
                    contents = new byte[len];
                    inStream.read(contents, 0, len);
                    inStream.close();
                    inStream = null;
                    byArray2 = contents;
                    Object var7_8 = null;
                    if (inStream == null) break block7;
                    inStream.close();
                }
                inStream = null;
                return byArray2;
            }
            try {
                byArray = null;
                Object var7_9 = null;
                if (inStream == null) break block8;
            }
            catch (Exception e) {
                try {
                    throw e;
                }
                catch (Throwable throwable) {
                    Object var7_10 = null;
                    if (inStream != null) {
                        inStream.close();
                    }
                    inStream = null;
                    throw throwable;
                }
            }
            inStream.close();
        }
        inStream = null;
        return byArray;
    }

    private static void printUsage() {
        System.out.println("Usage\n\t(1):    /wsdl WSDLFileNameorURL [/op operationName] [/in inputMsgFile]");
        System.out.println("\n\n\t(2):    /ni #ofXMLinstance /i1 XML_instance_filename1 ... /iN XML_instance_filenameN /ns #ofschemas /s1 schemafile1  ... /sN schemafileN.");
        System.out.println("\n\t(3):    /i XML_instance_fileName /s schema_filename");
        System.out.println("   or:  /inputfile=parameterinputfile");
        System.exit(0);
    }
}

